# Conducting Media (Physical Layer)

## Definition
Conducting media refers to the physical materials that are used to transmit data in a network. These materials conduct electrical signals that represent the data.

## Types of Conducting Media
1. **Twisted Pair Cable:** This is the most common type of conducting media. It consists of pairs of copper wires twisted together. There are two types: Unshielded Twisted Pair (UTP) and Shielded Twisted Pair (STP).
2. **Coaxial Cable:** This type of cable has a single copper conductor at its center. A plastic layer provides insulation between the center conductor and a metal shield. The metal shield helps to block any outside interference from fluorescent lights, motors, and other computers.
3. **Fiber-Optic Cable:** This type of cable uses light to transmit data. It consists of one or more fibres, each of which can transmit data over long distances.

## Role of Conducting Media in the Physical Layer
The Physical Layer is responsible for transmitting data over the physical medium. In the case of conducting media, this involves converting the data into electrical signals (or light signals, in the case of fiber-optic cable) and transmitting these signals over the appropriate medium.

#### Key Insights

- The physical layer is an important part of computer networks, but it is often not well-understood by computer scientists. This video aims to provide a superficial understanding of the physical layer and its components.
- Conducting media, such as copper cables, play a crucial role in carrying messages across computers. Different types of copper cables, such as coaxial cables and twisted pairs, are used for data communication.
- Optical fiber is a high-speed transmission medium that offers advantages over traditional copper cables. It is made of glass and can transmit data using light signals.
- Connecting and testing cables is an essential part of network setup. Different tools, connectors, and techniques are used to connect and test cables, ensuring proper data transmission.
- Optical fiber installation can be done through various methods, including aerial installation on telephone poles, burial in underground cables, or using conduits. It provides fast and reliable data transmission with minimal interference.
- Power over Ethernet (PoE) is a useful technology for powering devices, such as wireless access points and security cameras, in locations where accessing power outlets is difficult.
- The next video will focus on radiated media, exploring different types of media used for broadcasting and transmitting information in multiple directions.